<?php
session_start();
include 'config.php';

if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit();
}

// Dosya yükleme işlemi
if (isset($_FILES['file'])) {
    $file_name = $_FILES['file']['name'];
    $file_tmp = $_FILES['file']['tmp_name'];
    $upload_path = 'uploads/' . basename($file_name);

    if (move_uploaded_file($file_tmp, $upload_path)) {
        $stmt = $conn->prepare("INSERT INTO files (filename) VALUES (?)");
        $stmt->bind_param("s", $file_name);
        $stmt->execute();
        $stmt->close();
        $message = "Dosya başarıyla yüklendi.";
    } else {
        $error = "Dosya yükleme hatası.";
    }
}

$sql_files = "SELECT id, filename FROM files";
$result_files = $conn->query($sql_files);
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <title>Ana Sayfa</title>
</head>
<body>
    <h2>Ana Sayfa</h2>
    <form action="index.php" method="post" enctype="multipart/form-data">
        Dosya Yükle: <input type="file" name="file" required><br>
        <input type="submit" value="Yükle">
    </form>
    <?php if (isset($message)): ?>
        <p><?php echo htmlspecialchars($message); ?></p>
    <?php elseif (isset($error)): ?>
        <p><?php echo htmlspecialchars($error); ?></p>
    <?php endif; ?>
    
    <h3>Yüklenen Dosyalar</h3>
    <ul>
        <?php while ($row = $result_files->fetch_assoc()): ?>
            <li><?php echo htmlspecialchars($row['filename']); ?></li>
        <?php endwhile; ?>
    </ul>

    <a href="logout.php">Çıkış Yap</a>
</body>
</html>
